# Usage Guide

Complete guide to using Kleopatra on macOS with drag-and-drop file operations.

## 🚀 Getting Started

### Launch Kleopatra

**Recommended Method (Terminal):**
```bash
open $(brew --prefix)/Applications/kleopatra.app
```
*Provides better file system access*

**Alternative Methods:**
```bash
# Command line
kleopatra

# Applications folder
# Find "kleopatra" in Applications and double-click
```

## 🎯 File Operations (Drag & Drop Method)

### ⚠️ Important: Why Drag & Drop?

The **Sign/Encrypt buttons** and **File menu** don't work due to macOS sandboxing restrictions. 

✅ **Drag & Drop works perfectly** and is actually faster once you get used to it!

### 📁 Signing Files

1. **Open Kleopatra**
2. **Drag any file** from Finder onto the Kleopatra window
3. **Select "Sign/Encrypt..."** from the popup menu
4. **Choose signing options:**
   - ✅ **Sign** (check this box)
   - ⬜ **Encrypt** (optional)
5. **Select your key** from the dropdown
6. **Click "Sign/Encrypt"**

**Result:** Creates `.gpg` or `.sig` file with your signature

### 🔒 Encrypting Files

1. **Drag file** onto Kleopatra window
2. **Select "Sign/Encrypt..."**
3. **Choose encryption options:**
   - ⬜ **Sign** (optional but recommended)
   - ✅ **Encrypt** (check this box)
4. **Select recipient keys** (can be multiple)
5. **Click "Sign/Encrypt"**

**Result:** Creates encrypted `.gpg` file

### 🔓 Decrypting/Verifying Files

1. **Drag encrypted/signed file** (.gpg, .sig, .asc) onto Kleopatra
2. **Select "Decrypt/Verify..."**
3. **Enter passphrase** if prompted
4. **Review results** in the verification dialog

**Result:** Original file extracted and/or signature verified

## 📝 Practical Examples

### Example 1: Sign a Document
```bash
# Create test document
echo "This is a confidential document." > important.txt

# Drag important.txt onto Kleopatra window
# Select: Sign/Encrypt... → Check "Sign" → Choose your key → Sign/Encrypt
# Result: important.txt.gpg or important.txt.sig
```

### Example 2: Encrypt for Multiple Recipients
```bash
# Create document
echo "Secret project notes" > project.txt

# Drag project.txt onto Kleopatra window  
# Select: Sign/Encrypt... → Check both "Sign" and "Encrypt"
# Choose multiple recipients from the list
# Result: project.txt.gpg (signed and encrypted)
```

### Example 3: Verify Downloaded File
```bash
# Download file with signature
curl -O https://example.com/software.zip
curl -O https://example.com/software.zip.sig

# Drag software.zip.sig onto Kleopatra window
# Select: Decrypt/Verify...
# View signature verification results
```

## 🗝️ Key Management

### Creating Your First Key Pair

1. **File** → **New Key Pair** (this menu works!)
2. **Select "Create a personal OpenPGP key pair"**
3. **Enter your details:**
   - Name: Your full name
   - Email: Your email address  
   - Comment: Optional (e.g., "Work key", "Personal")
4. **Advanced settings** (optional):
   - Key size: 3072 or 4096 bits
   - Expiration: Set expiration date (recommended)
5. **Create key** and set a strong passphrase

### Importing Keys

**Method 1: Drag & Drop**
- Drag `.asc`, `.gpg`, or key files onto Kleopatra window
- Confirm import in the dialog

**Method 2: Built-in Import**
- **File** → **Import Certificates**
- Select key files or paste key text

**Method 3: Key Servers**
- **File** → **Lookup Certificates on Server**
- Search by email or key ID

### Exporting Keys

**Export Public Key:**
1. Right-click on your key
2. **Export Certificate...**
3. Choose location and format

**Export Private Key:**
1. Right-click on your key
2. **Export Secret Key...**  
3. ⚠️ **Keep this secure!**

## 📱 Built-in Notepad

The built-in notepad works normally and is great for quick text signing/encryption:

1. **File** → **Notepad** (or Cmd+Shift+N)
2. Type your message
3. **File** → **Sign/Encrypt Notepad**
4. Choose options and recipients
5. **Copy result** or save to file

## 🔧 Advanced Features

### Smartcard Support

If you have a hardware security key:

1. **Settings** → **Configure Kleopatra**
2. **GnuPG System** → **Smartcards**
3. Insert card and follow prompts

### Certificate Validation

**Check Certificate Status:**
1. Right-click certificate
2. **Certificate Details**
3. Review trust level and validity

**Change Trust Level:**
1. Right-click certificate  
2. **Change Owner Trust**
3. Select appropriate trust level

### Batch Operations

For multiple files:
1. Select multiple files in Finder
2. Drag all files onto Kleopatra at once
3. Choose operation for all files
4. Process runs automatically

## 🎨 User Interface Tips

### Main Window Sections

- **My Certificates**: Your private keys
- **Trusted Certificates**: Public keys you trust
- **Other Certificates**: Imported public keys

### Useful Keyboard Shortcuts

- **Cmd+N**: New key pair
- **Cmd+I**: Import certificates  
- **Cmd+Shift+N**: Open notepad
- **Cmd+R**: Refresh certificate list
- **Cmd+F**: Search certificates

### Status Indicators

- 🟢 **Green lock**: Valid, trusted certificate
- 🟡 **Yellow warning**: Expired or untrusted
- 🔴 **Red error**: Invalid or revoked
- 🔵 **Blue key**: Your private key

## 🚨 Common Scenarios

### "File not found" after encryption
**Solution**: Check the output location specified during encryption. Files are saved where you choose, not necessarily the same folder.

### Large file operations
**Tip**: Kleopatra handles large files well. Progress bars show during operations. Be patient with multi-GB files.

### Email integration
**macOS Mail**: Export signed/encrypted files and attach them manually. Direct integration isn't available.

### Terminal integration
```bash
# Sign file directly with GPG
gpg --detach-sign document.txt

# Encrypt for recipient  
gpg --encrypt --recipient user@example.com document.txt

# List keys
gpg --list-keys
```

## 📚 Next Steps

- **Key Distribution**: Share your public key via email or key servers
- **Web of Trust**: Sign other people's keys after verifying identity
- **Backup**: Export and securely store your private keys
- **Expiration**: Set calendar reminders for key expiration dates

## 🆘 Need Help?

- **Drag & Drop not working?** → [Troubleshooting Guide](troubleshooting.md)
- **Permission issues?** → Grant Full Disk Access in System Settings
- **GPG errors?** → Check [Development Guide](development.md) for debugging

Remember: **Drag & Drop is your friend!** 🎯 It's fast, reliable, and works great once you get the hang of it.