# Installation Guide

Complete guide to installing Kleopatra on macOS using Homebrew.

## System Requirements

- **macOS 12.0 (Monterey) or newer**
- **Homebrew** package manager
- **~1GB free disk space** for dependencies
- **Administrative privileges** (for some system configurations)

## Quick Installation

### 1. Add the Homebrew Tap
```bash
brew tap yourusername/kleopatra-modern
```

### 2. Install Kleopatra
```bash
brew install kleopatra
```

### 3. Launch Kleopatra
```bash
# Option 1: Command line
kleopatra

# Option 2: GUI (Applications folder)
open /Applications/kleopatra.app

# Option 3: Terminal launch (recommended for better file access)
open $(brew --prefix)/Applications/kleopatra.app
```

## Detailed Installation Steps

### Prerequisites Check

1. **Verify Homebrew Installation**:
   ```bash
   brew --version
   ```
   If not installed, get Homebrew from [brew.sh](https://brew.sh)

2. **Check macOS Version**:
   ```bash
   sw_vers -productVersion
   ```
   Must be 12.0 or newer.

3. **Free Up Disk Space**:
   ```bash
   df -h /
   ```
   Ensure at least 1GB available.

### Installation Process

The installation will automatically:
- Download Kleopatra 24.02.2 source code
- Install all KDE Frameworks 6 dependencies
- Build Qt6-based application
- Configure GPG and DBus services
- Set up proper macOS integration

### Dependencies Installed

**Build Tools:**
- cmake, ninja, pkg-config
- extra-cmake-modules, gettext

**Runtime Libraries:**
- Qt6 (GUI framework)
- GPG suite (gnupg, gpgme, libassuan, libgpg-error)
- KDE Frameworks 6 (40+ libraries)
- DBus (system messaging)
- Boost (C++ libraries)

### Post-Installation Setup

#### 1. Verify Installation
```bash
kleopatra --version
```

#### 2. Test Drag-and-Drop
1. Launch Kleopatra
2. Create a test file: `echo "Hello World" > test.txt`
3. Drag `test.txt` onto Kleopatra window
4. Select "Sign/Encrypt..." from popup menu

#### 3. Configure Services
```bash
# Start DBus (required)
brew services start dbus

# Restart GPG agent (if needed)
killall -9 gpg-agent
```

#### 4. Grant Full Disk Access (Optional)
For maximum compatibility:
1. **System Settings** → **Privacy & Security** → **Full Disk Access**
2. Click **"+"** and add: `$(brew --prefix)/Applications/kleopatra.app/Contents/MacOS/kleopatra`
3. Restart Kleopatra

## Installation Troubleshooting

### Build Failures

**Missing Dependencies:**
```bash
# Update Homebrew first
brew update && brew upgrade

# Reinstall if needed
brew uninstall kleopatra
brew install kleopatra
```

**KDE Framework Issues:**
```bash
# Check for missing KF6 packages
brew list | grep kf6-

# Reinstall core frameworks if needed
brew reinstall kf6-kcoreaddons kf6-kconfig kf6-ki18n
```

### Runtime Issues

**"Command not found":**
```bash
# Add Homebrew to PATH
echo 'export PATH="/opt/homebrew/bin:$PATH"' >> ~/.zshrc
source ~/.zshrc
```

**DBus Connection Failed:**
```bash
# Restart DBus service
brew services restart dbus

# Check DBus status
brew services list | grep dbus
```

**GPG Agent Problems:**
```bash
# Reset GPG agent
killall -9 gpg-agent
gpg-agent --daemon
```

### Permission Issues

**Drag-and-Drop Not Working:**
1. Launch from Terminal: `open $(brew --prefix)/Applications/kleopatra.app`
2. Grant Full Disk Access (see step 4 above)
3. Try different file locations (Desktop, Documents)

**Certificate Import Fails:**
```bash
# Check GPG directory permissions
ls -la ~/.gnupg/
chmod 700 ~/.gnupg/
chmod 600 ~/.gnupg/*
```

## Alternative Installation Methods

### Build from Source
```bash
# Clone this repository
git clone https://github.com/yourusername/homebrew-kleopatra-modern.git
cd homebrew-kleopatra-modern

# Install using local formula
brew install --build-from-source ./Formula/kleopatra.rb
```

### Development Build
```bash
# Install HEAD version (latest git)
brew install kleopatra --HEAD
```

## Uninstallation

### Complete Removal
```bash
# Remove Kleopatra
brew uninstall kleopatra

# Remove tap (optional)
brew untap yourusername/kleopatra-modern

# Clean up dependencies (optional)
brew autoremove
```

### Keep Configuration
To preserve GPG keys and settings, keep these directories:
- `~/.gnupg/` (GPG configuration and keys)
- `~/Library/Preferences/org.kde.kleopatra.plist` (Kleopatra settings)

## Next Steps

After successful installation:
1. Read the [Usage Guide](usage.md) for drag-and-drop instructions
2. Check [Troubleshooting](troubleshooting.md) for common issues
3. Configure your GPG keys and certificates

## Support

- **Issues**: [GitHub Issues](https://github.com/yourusername/homebrew-kleopatra-modern/issues)
- **Formula Testing**: `brew test kleopatra`
- **Verbose Logs**: `brew install kleopatra --verbose`