# Homebrew Kleopatra Modern

[![CI](https://github.com/yourusername/homebrew-kleopatra-modern/actions/workflows/test.yml/badge.svg)](https://github.com/yourusername/homebrew-kleopatra-modern/actions/workflows/test.yml)

A modern Homebrew tap for **Kleopatra** - the KDE certificate manager and GUI for OpenPGP and CMS cryptography, built with Qt6 and KDE Frameworks 6.

## 🔐 What is Kleopatra?

Kleopatra is a powerful certificate manager that provides:
- **PGP Key Management** - Create, import, export, and manage OpenPGP keys
- **File Encryption/Decryption** - Secure your documents and files
- **Digital Signatures** - Sign and verify file authenticity
- **Certificate Management** - Handle both PGP and X.509 certificates
- **Smartcard Support** - Work with hardware security tokens
- **Built-in Notepad** - Sign and encrypt text directly

## 🚀 Installation

### Quick Install
```bash
brew tap yourusername/kleopatra-modern
brew install kleopatra
```

### Requirements
- **macOS Monterey (12.0) or newer**
- **Homebrew** package manager
- **~1GB disk space** for dependencies

## 📖 Usage

### 🎯 **IMPORTANT: How to Sign/Encrypt Files**

⚠️ **The Sign/Encrypt buttons and File menu don't work** due to macOS sandboxing restrictions.

✅ **Use Drag & Drop instead** (it's actually faster!):

1. **Launch Kleopatra** (Applications folder or `kleopatra` command)
2. **Drag any file** from Finder directly onto the Kleopatra window
3. **Choose your action**:
   - `Sign/Encrypt...` - Sign and/or encrypt the file
   - `Decrypt/Verify...` - Decrypt and/or verify signatures
4. **Complete the operation** using the dialogs that appear

![Drag and Drop Demo](docs/drag-drop-demo.gif)

### Other Functions That Work Normally:
- ✅ Creating new PGP keys
- ✅ Managing certificates and keyring
- ✅ Built-in notepad (File → Notepad)
- ✅ Import/export keys
- ✅ All settings and configuration

## 🔧 Troubleshooting

### "Nothing happens when I click Sign/Encrypt"
This is expected! Use **drag and drop** instead - it's a known limitation of the macOS port.

### Permission Issues
If drag & drop doesn't work, grant **Full Disk Access**:
1. **System Settings** → **Privacy & Security** → **Full Disk Access**
2. **Click "+" and add**: `/Applications/kleopatra.app/Contents/MacOS/kleopatra`
3. **Restart Kleopatra**

### DBus Not Running
```bash
brew services start dbus
```

### GPG Agent Issues
```bash
killall -9 gpg-agent
kleopatra  # Restart Kleopatra
```

## 🆚 Why This Tap?

### vs. algertc/homebrew-kleopatra4mac
- ✅ **Modern**: Qt6 + KDE Frameworks 6 (vs Qt5)
- ✅ **Current**: Kleopatra 24.02.2 (vs 22.07.80)
- ✅ **Maintained**: Active development (vs abandoned 2+ years)
- ✅ **Better docs**: Clear usage instructions with drag-and-drop

### vs. Building from Source
- ✅ **Simple**: One-command install vs complex build process
- ✅ **Reliable**: Tested formula vs manual dependency management
- ✅ **Fast**: Pre-built bottles when available

## 🏗️ Advanced Usage

### Launch from Terminal (Recommended)
Launching from Terminal gives better file access:
```bash
open /Applications/kleopatra.app
```

### Manual GPG Operations
For command-line users:
```bash
# Sign a file
gpg --detach-sign document.txt

# Verify signature  
gpg --verify document.txt.sig document.txt

# List your keys
gpg --list-secret-keys
```

### Configuration Files
- GPG config: `~/.gnupg/gpg.conf`
- GPG agent: `~/.gnupg/gpg-agent.conf` (auto-configured)
- Kleopatra settings: `~/Library/Preferences/org.kde.kleopatra.plist`

## 📚 Documentation

- [Installation Guide](docs/installation.md)
- [Usage Examples](docs/usage.md) 
- [Troubleshooting](docs/troubleshooting.md)
- [Development](docs/development.md)

## 🤝 Contributing

Contributions welcome! Please:
1. **Fork** this repository
2. **Create a feature branch**: `git checkout -b my-feature`
3. **Test your changes** thoroughly
4. **Submit a pull request**

### Testing the Formula
```bash
brew install --build-from-source ./Formula/kleopatra.rb
brew test kleopatra
```

## 📄 License

- **Formula**: MIT License
- **Kleopatra**: GPL-2.0+ and LGPL-2.1+ (KDE project)

## 🙏 Credits

- **KDE Community** - Original Kleopatra development
- **algertc** - Pioneer macOS port (homebrew-kleopatra4mac)  
- **Paul Applegate** - Modern KF6/Qt6 port and Homebrew formula

## 💬 Support

- **Issues**: [GitHub Issues](https://github.com/yourusername/homebrew-kleopatra-modern/issues)
- **Discussions**: [GitHub Discussions](https://github.com/yourusername/homebrew-kleopatra-modern/discussions)
- **KDE Community**: [KDE forums](https://discuss.kde.org/)

---

**Remember**: Use **drag & drop** for file operations - it works great! 🎯